<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title>Consulta de Tweets</title>
	<style>
		@import url('https://fonts.googleapis.com/css?family=Raleway');
		body {
			font-family: Arial, sans-serif;
			margin: 0;
			padding: 0;
		}
		h1 {
			background-color: #333;
			color: #fff;
			padding: 20px;
			margin: 0;
		}
		form {
			background-color: #f2f2f2;
			padding: 20px;
		}
		label {
			display: block;
			margin-bottom: 10px;
		}
		input[type="submit"] {
			background-color: #333;
            color: white;
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 3px;
            cursor: pointer;
		}
		table {
			border-collapse: collapse;
			width: 100%;
			margin-top: 20px;
		}
		th, td {
			padding: 10px;
			text-align: left;
			border: 1px solid #ddd;
			font-size: 11px;
		}
		th {
			background-color: #007bff;
			color: #fff;
		}
		tfoot {
			font-weight: bold;
			background-color: #f2f2f2;
		}
	</style>
</head>
<body>
	<h1>Consulta Filtrada de Tweets</h1>
	<button style="margin: 10px" onclick="location.href='menu.html'">Regresar a menu</button> 
  	<!-- <button onclick="location.href='exporta_excel_tweets.php'">Exporta a Excel</button> -->
	<form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
		<label for="fecha_inicial">Fecha Inicial:</label>
		<input type="date" name="fecha_inicial" required>
		<label for="fecha_final">Fecha Final:</label>
		<input type="date" name="fecha_final" required>
		<input type="submit" value="Buscar">
	</form>
	<?php
		if ($_SERVER["REQUEST_METHOD"] == "POST") {
		    require_once 'conexion.php';

		    // Obtener las fechas del formulario
		    $fecha_inicial = $_POST["fecha_inicial"];
		    $fecha_final = $_POST["fecha_final"];

		    // Consulta SQL para seleccionar los tweets entre las fechas especificadas
		    $sql = "SELECT * FROM tweets WHERE created_at >= '$fecha_inicial' AND created_at <= '$fecha_final'";

		    $resultado = mysqli_query($conn, $sql);
		    if (mysqli_num_rows($resultado) > 0) {
		        // Mostrar los resultados en una tabla HTML
		        echo "<table>";
		        echo "<thead><tr><th>Tweet ID</th><th>Fecha de creación</th><th>Texto</th><th>ID de usuario</th><th>Nombre de usuario</th><th>Seguidores</th><th>Siguiendo</th><th>Retweets</th><th>Likes</th></tr></thead>";
		        echo "<tbody>";
		        $retweets_total = 0;
		        $likes_total = 0;
		        while ($fila = mysqli_fetch_assoc($resultado)) {
		            echo "<tr>";
		            echo "<td>" . $fila["tweet_id"] . "</td>";
		            echo "<td>" . $fila["created_at"] . "</td>";
		            echo "<td>" . $fila["text"] . "</td>";
		            echo "<td>" . $fila["user_id"] . "</td>";
		            echo "<td>" . $fila["user_name"] . "</td>";
		            echo "<td>" . $fila["seguidores"] . "</td>";
		            echo "<td>" . $fila["siguiendo"] . "</td>";
		            echo "<td>" . $fila["retweets"] . "</td>";
		            echo "<td>" . $fila["likes"] . "</td>";
		            echo "</tr>";
		            $retweets_total += $fila["retweets"];
		            $likes_total += $fila["likes"];
		        }
		        echo "</tbody>";
		        echo "<tfoot>";
		        echo "<tr><td colspan='7'>Total:</td><td>" . $retweets_total . "</td><td>" . $likes_total . "</td></tr>";
		        echo "<tr><td colspan='9'>Número de registros: " . mysqli_num_rows($resultado) . "</td></tr>";
		        echo "</tfoot>";
		        echo "</table>";
		    } else {
		        echo "No se encontraron resultados.";
		    }

		    // Cerrar la conexión a la base de datos
		    mysqli_close($conn);
		}
		?>
</body>
</html>

