<?php
    require_once 'vendor/autoload.php';


    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    // Crear un nuevo objeto Spreadsheet
    $spreadsheet = new Spreadsheet();

    // Seleccionar la hoja activa del archivo Excel
    $hoja = $spreadsheet->getActiveSheet();

    // Establecer los encabezados de las columnas
    $hoja->setCellValue('A1', 'ID');
    $hoja->setCellValue('B1', 'Fecha de creación');
    $hoja->setCellValue('C1', 'Texto');
    $hoja->setCellValue('D1', 'ID de usuario');
    $hoja->setCellValue('E1', 'Nombre de usuario');
    $hoja->setCellValue('F1', 'Seguidores');
    $hoja->setCellValue('G1', 'Siguiendo');
    $hoja->setCellValue('H1', 'Retweets');
    $hoja->setCellValue('I1', 'Likes');

    // Consulta para obtener los registros de la tabla "tweets"

    $servername = "localhost";
    $username = "zttsoftn_uelec";
    $password = "zttsoft";
    $dbname = "zttsoftn_elec2023";

    // Conexión a la base de datos
    $conn = mysqli_connect($servername, $username, $password, $dbname);

    // Verificar si se ha producido algún error en la conexión
    if (!$conn) {
        die("Error en la conexión a la base de datos: " . mysqli_connect_error());
    }

    $sql = "SELECT * FROM tweets";
    $resultado = mysqli_query($conn, $sql);

    // Agregar los datos a las celdas correspondientes
    $fila = 2;
    while ($registro = mysqli_fetch_assoc($resultado)) {
        $hoja->setCellValue('A' . $fila, $registro['tweet_id']);
        $hoja->setCellValue('B' . $fila, $registro['created_at']);
        $hoja->setCellValue('C' . $fila, $registro['text']);
        $hoja->setCellValue('D' . $fila, $registro['user_id']);
        $hoja->setCellValue('E' . $fila, $registro['user_name']);
        $hoja->setCellValue('F' . $fila, $registro['seguidores']);
        $hoja->setCellValue('G' . $fila, $registro['siguiendo']);
        $hoja->setCellValue('H' . $fila, $registro['retweets']);
        $hoja->setCellValue('I' . $fila, $registro['likes']);
        $fila++;
    }

    // Crear un nuevo objeto Writer para guardar el archivo Excel
    $writer = new Xlsx($spreadsheet);

    // Obtener el estilo de la columna H
    $style = $hoja->getStyle('A');

    // Establecer el formato numérico sin decimales
    $style->getNumberFormat()->setFormatCode('0');

    // Guardar el archivo Excel en el servidor
    $writer->save('tweets.xlsx');

    // Descargar el archivo Excel generado al navegador del usuario
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="tweets.xlsx"');
    header('Cache-Control: max-age=0');
    $writer->save('php://output');
    exit;
?>
