<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title>Consulta de Tweets</title>
	<link rel="stylesheet" type="text/css" href="css/tabla_tweets.css">
	<script src='jquery.js'></script>
        <script src='tablesorter/dist/js/jquery.tablesorter.min.js'></script>
        <script>
            $(function() {
              // initial sort set using data-sortlist attribute (see HTML below)
               $(".table2").tablesorter({
                    theme: 'blackice',
                    headerTemplate: '{content}{icon}',
                    onRenderTemplate: null
                  });
            });
        </script>
	
	
</head>
<body>
	<header>
        <h1>Consulta Filtrada de Tweets</h1>
    </header>
	<a href="menu.html" class="button">Regresar a menu</a>
	<form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
	  <div class="form-group">
	    <label for="fecha_inicial">Fecha Inicial:</label>
	    <input type="date" name="fecha_inicial" required>
	  </div>
	  <div class="form-group">
	    <label for="fecha_final">Fecha Final:</label>
	    <input type="date" name="fecha_final" required>
	  </div>
	  <div class="form-group">
	    <label for="user_name">Usuario:</label>
	    <input type="text" name="user_name" required>
	  </div>
	  <input type="submit" value="Buscar">
	</form>


	<?php
		if ($_SERVER["REQUEST_METHOD"] == "POST") {
		    require_once 'conexion.php';

		     // Obtener las fechas y el nombre de usuario del formulario
		    $fecha_inicial = $_POST["fecha_inicial"];
		    $fecha_final = $_POST["fecha_final"];
		    $user_name = $_POST["user_name"];

		    // Consulta SQL para seleccionar los tweets entre las fechas especificadas y con el nombre de usuario especificado
		    $sql = "SELECT * FROM tweets WHERE created_at BETWEEN '$fecha_inicial' AND '$fecha_final'";

		    if(isset($_POST["user_name"]) && !empty($_POST["user_name"])) {
		        $user_name = $_POST["user_name"];
		        $sql .= " AND user_name = '$user_name'";
		    }

		    $resultado = mysqli_query($conn, $sql);
		    if (mysqli_num_rows($resultado) > 0) {
		        // Mostrar los resultados en una tabla HTML
		        // echo "<div swf_fontsize(8px);'>Puede ordenar la tabla dando clik sobre alguna de las columnas</div>";
		        echo "<div class='notita'>*Puede ordenar la tabla dando clik sobre alguna de las columnas</div>";
		        echo "<table class='table2' data-sortlist='[[0,0],[2,0]]''>";
		        echo "<thead><tr><th>Tweet ID</th><th>Fecha de creación</th><th>Texto</th><th>ID de usuario</th><th>Nombre de usuario</th><th>Seguidores</th><th>Siguiendo</th><th>Retweets</th><th>Likes</th></tr></thead>";
		        echo "<tbody>";
		        $retweets_total = 0;
		        $likes_total = 0;
		        while ($fila = mysqli_fetch_assoc($resultado)) {
		            echo "<tr>";
		            echo "<td>" . $fila["tweet_id"] . "</td>";
		            echo "<td>" . $fila["created_at"] . "</td>";
		            echo "<td>" . $fila["text"] . "</td>";
		            echo "<td>" . $fila["user_id"] . "</td>";
		            echo "<td>" . $fila["user_name"] . "</td>";
		            echo "<td>" . $fila["seguidores"] . "</td>";
		            echo "<td>" . $fila["siguiendo"] . "</td>";
		            echo "<td>" . $fila["retweets"] . "</td>";
		            echo "<td>" . $fila["likes"] . "</td>";
		            echo "</tr>";
		            $retweets_total += $fila["retweets"];
		            $likes_total += $fila["likes"];
		        }
		        echo "</tbody></table>";
		        $num_registros = mysqli_num_rows($resultado);
		        
		        echo "<div style='text-align: right; margin-top: 20px; margin-right:50px'>";
                echo "Total de Tweets: <b>" . number_format($num_registros) . "</b><br>";
                echo "Total Retweets: <b>" . number_format($retweets_total) . "</b><br>";
                echo "Total Likes: <b>" . number_format($likes_total) . "</b>";
                echo "</div>";
		    } else {
		        echo "No se encontraron resultados.";
		    }

		    // Cerrar la conexión a la base de datos
		    mysqli_close($conn);
		}

		?>
</body>
</html>

