<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        @import url('https://fonts.googleapis.com/css?family=Raleway');
        body {
            background-color: #f2f2f2;
            font-family: 'Raleway', sans-serif;
        }

        .loading {
            /* font-family: 'Realway'; */
            font-size: 24px;
            position: fixed;
            color: #444;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
    </style>
</head>
<body>

<?php

require_once 'conexion.php';


error_reporting(E_ALL);
ini_set('display_errors', 1);

// Obtener el nombre de usuario y el número de tweets de la URL y se establecen valores por defecto
if (isset($_GET['user'])) {
    $user = preg_replace("/[^A-Za-z0-9_]/", '', $_GET['user']);
} else {
    $user = "Luis_ZanattaB"; // Usuario predeterminado si no se especifica en la URL
}
if (isset($_GET['count']) && is_numeric($_GET['count'])) {
    $count = $_GET['count'];
} else {
    $count = 20; // Número predeterminado de tweets si no se especifica en la URL
}

$api_key = 'M22ScrYvCW0wkWQxzVfBUUA67'; // Reemplaza con tu API Key de Twitter
$api_secret_key = 'qbDz3adhFYoCHUlyI9T0PG1327cfSxq9qWaGNZysrRE1yup77d'; // Reemplaza con tu API Secret Key de Twitter
$bearer_token = 'AAAAAAAAAAAAAAAAAAAAAHWgrAEAAAAAQR%2FctQaI7ACAYTdMkuvfAkohUrk%3Dk5NGnxtSYv4ZpX3nwbL9yGT1SY41A6gFOfESM5UsbkZazzBgzT'; // Reemplaza con tu Bearer Token de Twitter


// Configurar las credenciales de autenticación
$settings = array(
    'oauth_access_token' => $api_key,
    'oauth_access_token_secret' => $api_secret_key,
    'consumer_key' => $api_key,
    'consumer_secret' => $api_secret_key,
);

$url = "https://api.twitter.com/2/tweets/search/recent?query=from:$user&max_results=$count";

// Inicializar cURL
$ch = curl_init();

// Configurar la solicitud cURL
curl_setopt($ch, CURLOPT_URL, $url); // Establecer la URL
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Indicar que se quiere obtener el resultado como una cadena
curl_setopt($ch, CURLOPT_HTTPGET, true); // Indicar que se quiere usar el método GET
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    "Authorization: Bearer $bearer_token", // Establecer la cabecera de autorización con el Bearer Token
));

// Realizar la solicitud a la API de Twitter
$response = curl_exec($ch);

// Verificar si hubo errores en la solicitud cURL
if (curl_errno($ch)) {
    die("Error en la solicitud cURL: " . curl_error($ch));
}

// Decodificar la respuesta JSON a un arreglo asociativo
$tweets = json_decode($response, true);

// Verificar si 'data' está presente en la respuesta
if (isset($tweets['data'])) {
    // Recorrer los tweets y guardarlos en la tabla "tweets"
    foreach ($tweets['data'] as $tweet) {
        // ... (resto del código para guardar los tweets)
    }
} else {
    // Manejar el caso en que 'data' no está presente en la respuesta
    echo "La respuesta de la API de Twitter no tiene el formato esperado.";
}


// Cerrar la conexión cURL
curl_close($ch);

if (!is_array($tweets) || empty($tweets)) {
    die("Error al obtener los tweets de la API de Twitter.");
}

$tactualizados = 0;
$tinsertados = 0;

var_dump($tweets);

// Recorrer los tweets y guardarlos en la tabla "tweets"
foreach ($tweets['data'] as $tweet) {
    $id = $tweet['id'];
    $created_at = date("Y-m-d H:i:s", strtotime($tweet['created_at']));
    $text = mysqli_real_escape_string($conn, $tweet['text']);
    $user_id = $tweet['author_id'];

    // Puedes obtener más información adicional de los tweets a través de $tweet['public_metrics']

    // Insertar tweet en la tabla "tweets"
    $sql = "INSERT INTO tweets (tweet_id, created_at, text, user_id)
            VALUES ('$id', '$created_at', '$text', '$user_id')
            ON DUPLICATE KEY UPDATE text = '$text', created_at = '$created_at'";

    if (mysqli_query($conn, $sql)) {
        if (mysqli_affected_rows($conn) == 1) {
            // Incrementar el contador de tweets insertados
            $tinsertados++;
        } else if (mysqli_affected_rows($conn) == 2) {
            $tactualizados++;
        }
    } else {
        // Manejar errores aquí si es necesario
    }
}

// Mostrar mensaje de carga
echo '<div class="loading">Cargando Datos desde Twitter...</div>';
echo "Tweets Actualizados: " . $tactualizados . "<br>";
echo "Tweets Insertados  : " . $tinsertados . "<br>";

// Esperar 3 segundos antes de redireccionar
// header("refresh:3;url=tabla_tweets.php");

?>

</body>
</html>
