<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">

    <style>
        @import url('https://fonts.googleapis.com/css?family=Raleway');
        body {
            background-color: #f2f2f2;
            font-family: 'Raleway', sans-serif;
        }

        .loading {
              /* font-family: 'Realway'; */
              font-size: 24px;
              position: fixed;
              color: #444;
              top: 50%;
              left: 50%;
              transform: translate(-50%, -50%);
            }
    </style>


</head>
<body>


    <?php

    require_once 'conexion.php';
    // date_default_timezone_set('America/Mexico_City');
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    require_once('TwitterAPIExchange.php');

    // Establecer bearer token de acceso 
    $bearer_token = 'AAAAAAAAAAAAAAAAAAAAAPHMmgEAAAAAZUcZTTnNEeGr1Tz4u%2F9JXWzJ7PI%3DdcUgXswP2O67ZGmI3RVebnZA3H8hPBIVFEQfbouLBD567f3iWp';

    // Configurar opciones de cURL de solicitud con bearer token
    $options = array(
        CURLOPT_HTTPHEADER => array("Authorization: Bearer $bearer_token"),
        CURLOPT_SSL_VERIFYPEER => false );

    // Inicializar cURL
    $ch = curl_init();

    // Obtener el nombre de usuario y el número de tweets de la URL y se establecen valores por defecto
    if (isset($_GET['user'])) {
        $user = preg_replace("/[^A-Za-z0-9_]/", '', $_GET['user']);
    } else {
        $user = "DatoRaiz"; // Usuario predeterminado si no se especifica en la URL
    }
    if (isset($_GET['count']) && is_numeric($_GET['count'])) {
        $count = $_GET['count'];
    } else {
        $count = 20; // Número predeterminado de tweets si no se especifica en la URL
    }

    $getfield = "?screen_name=$user&count=$count&tweet_mode=extended";

    // Configurar opciones de cURL de solicitud con bearer token
    $options = array(
        CURLOPT_HTTPHEADER => array("Authorization: Bearer $bearer_token"),
        CURLOPT_SSL_VERIFYPEER => false );

    curl_setopt($ch, CURLOPT_URL, "https://api.twitter.com/1.1/statuses/user_timeline.json" . $getfield);
    curl_setopt_array($ch, $options);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // REALIZAR SOLICITUD A LA API DE TWITTER
    $response = curl_exec($ch);

    // Decodificar la respuesta JSON a un arreglo asociativo
    $tweets = json_decode($response, true);

    if (!is_array($tweets)) {
        die("Error al obtener los tweets de la API de Twitter.");
    }

    $tactualizados = 0 ;
    $tinsertados = 0 ;

    // Recorrer los tweets y guardarlos en la tabla "tweets"
    foreach ($tweets as $tweet) {
        $id = $tweet['id'];
        $created_at = date("Y-m-d H:i:s", strtotime($tweet['created_at']) - 21600) ; // Se restan 6 horas para ajustar al horario de México
        $text = mysqli_real_escape_string($conn, $tweet['full_text']);
        $user_id = $tweet['user']['id'];
        $user_name = mysqli_real_escape_string($conn, $tweet['user']['screen_name']);
        $retweet_count = $tweet['retweet_count'];
        $favorite_count = $tweet['favorite_count'];
        $followers_count = $tweet['user']['followers_count'];
        $friends_count = $tweet['user']['friends_count'];

        // Extraer hashtags y menciones del tweet
        preg_match_all('/#[^\s]+/', $text, $matches);
        $hashtags = implode(', ', $matches[0]);
        preg_match_all('/@[^\s]+/', $text, $matches);
        $mentions = implode(', ', $matches[0]);

        // Insertar tweet en la tabla "tweets"
        $sql = "INSERT INTO tweets (tweet_id, created_at, text, user_id, user_name, retweets, likes, seguidores, siguiendo, hashtags, menciones)
            VALUES ('$id', '$created_at', '$text', '$user_id', '$user_name', '$retweet_count', '$favorite_count', '$followers_count', '$friends_count', '$hashtags', '$mentions')
            ON DUPLICATE KEY UPDATE retweets = '$retweet_count', likes = '$favorite_count', hashtags = '$hashtags', menciones = '$mentions'";

        if (mysqli_query($conn, $sql)) {
            if (mysqli_affected_rows($conn) == 1) {
                // Incrementar el contador de tweets insertados
                $tinsertados++;
            } else if (mysqli_affected_rows($conn) == 2) {
                $tactualizados++ ;
            }
        } else {
            //echo "Error al insertar datos en la tabla tweets: " . mysqli_error($conn);
        }
    }


    // Mostrar mensaje de carga
    echo '<div class="loading">Cargando Datos desde Twitter...</div>';
    echo "Tweets Actualizados:" . $tactualizados . "<br>";
    echo "Tweets Insertados  :" . $tinsertados . "<br>";

    // Esperar 3 segundos antes de redireccionar
    header("refresh:3;url=tabla_tweets.php");

    ?>

</body>
</html>
