<!DOCTYPE html>
<html>
<head>
    <title>Búsqueda de Hashtags en Twitter</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 0;
        }
        h1 {
            text-align: center;
            margin-top: 30px;
        }
        form {
            width: 50%;
            margin: 0 auto;
            background-color: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
        }
        input[type="submit"] {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 10px;
            font-size: 16px;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #0062cc;
        }
        p {
            margin-top: 10px;
            font-size: 16px;
        }
       .resultados {
            background-color: #f8f8f8;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-top: 20px;
        }

        .error-message {
            background-color: #ffe5e5;
            padding: 10px;
            border: 1px solid #ffcccc;
            border-radius: 5px;
            margin-top: 20px;
        }

        button {
            background-color: #333;
            color: white;
            font-size: 12px;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            float: left;
            margin-top: 20px;
            margin-right: 20px;
        }

        button:hover {
            background-color: #444;
        }

        tr,td {
        	font-size: 11px ;
        	padding-right: 15px;
        }
        table {
		    border-collapse: collapse;
		    margin: auto;
		    width: 80%;
		}

		th, td {
		    border: 1px solid black;
		    padding: 10px;
		    text-align: center;
		}

		th {
		    background-color: #e6e6e6;
		}


    </style>
</head>
<body>
    
        <button onclick="location.href='menu.html'" style="margin-left: 20px;">Regresar a menu</button><br>

        <?php
        // Establecer el Bearer Token de acceso
        $bearer_token = 'AAAAAAAAAAAAAAAAAAAAAPHMmgEAAAAAZUcZTTnNEeGr1Tz4u%2F9JXWzJ7PI%3DdcUgXswP2O67ZGmI3RVebnZA3H8hPBIVFEQfbouLBD567f3iWp';

        // Obtener el valor del hashtag del formulario
        $hashtag = $_POST['hashtag'];
        $count = $_POST['contador'];

        // Verificar que el contador sea valido
        if (empty($count)) {
            $count = 100;
        }

        // Verificar que el hashtag no está vacío
        if (empty($hashtag)) {
            echo 'Por favor, ingrese uno o más hashtags separados por comas para realizar la búsqueda.';
        } else {
            // Convertir la lista de hashtags en un array
            $hashtags_array = explode(',', $hashtag);

            // Configurar opciones de cURL de solicitud con Bearer Token
            $options = array(
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer ' . $bearer_token,
                    'Content-Type: application/json'
                ),
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_RETURNTRANSFER => true
            );

            foreach ($hashtags_array as $hashtag_item) {
                // Configurar los parámetros de búsqueda
                $getfield = '?q=' . urlencode($hashtag_item) . '&count=' . $count;

                // Inicializar cURL
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.twitter.com/1.1/search/tweets.json' . $getfield);
                curl_setopt_array($ch, $options);

                // REALIZAR SOLICITUD A LA API DE TWITTER
                $response = curl_exec($ch);

                // PROCESAR RESPUESTA
                if ($response === false) {
                    echo 'Error al realizar la solicitud a la API de Twitter: ' . curl_error($ch);
                } else {
                    $tweets = json_decode($response);
                    if (isset($tweets->errors)) {
                        echo 'Error al obtener la información del tweet: ' . $tweets->errors[0]->message;
                    } else {
                        // Contar los tweets que contienen el hashtag
                        $contador = 0;
                        $retweets = 0;
                        $favoritos = 0;
                        $nombres = array() ;
                        $screen_names = array();
                        foreach ($tweets->statuses as $tweet) {
                            if (strpos($tweet->text, $hashtag_item) !== false) {
                                $contador++;
                                $retweets += $tweet->retweet_count;
                                $favoritos += $tweet->favorite_count;
                                $nombres[] = $tweet->user->name ;
                                $screen_names[] = $tweet->user->screen_name ; 
                            }
                        }

                        // Mostrar el resultado
                        echo '<div class="resultados">';
							echo '<p>El hashtag <strong>' . $hashtag_item . '</strong> se ha encontrado en <strong>' . $contador . '</strong> tweets.</p>';
							echo '<p>La cantidad total de retweets es: <strong>' . $retweets . '</strong></p>';
							echo '<p>La cantidad total de favoritos es: <strong>' . $favoritos . '</strong></p>';



	                        $contador_nombres = array();
							foreach ($nombres as $nombre) {
							    $nombre_trimeado = trim($nombre);
							    $contador_nombres[$nombre_trimeado] = isset($contador_nombres[$nombre_trimeado]) ? $contador_nombres[$nombre_trimeado] + 1 : 1;
							}

							echo '<table>';
                                echo '<tr><th>Nombre</th><th>Screen Name</th><th>Ocurrencias</th></tr>';
                                foreach ($contador_nombres as $nombre => $ocurrencias) {
                                    $indice = array_search($nombre, $nombres);
                                    $screen_name = $screen_names[$indice];
                                    echo '<tr>';
                                    echo '<td>' . $nombre . '</td>';
                                    echo '<td>' . $screen_name . '</td>';
                                    echo '<td>' . $ocurrencias . '</td>';
                                    echo '</tr>';
                                }
                            echo '</table>';

                        echo '</div>';
                    } 
                    
                    // limpiando array de $nombres
                    foreach ($nombres as $i => $value) { 
                    	unset($nombres[$i]); 
                    	unset($contador_nombres[$i]) ;
                    }

                }

                // Cerrar la conexión cURL
                curl_close($ch);
            }
        }
        ?>


</body>
</html>

