<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">  
        <title>Tweets</title>
        <link rel="stylesheet" type="text/css" href="css/tabla_tweets.css">
        <link rel="stylesheet" type="text/css" href="css/searchbox.css">

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src='tablesorter/dist/js/jquery.tablesorter.min.js'></script>

        <script>
            $(function() {
              // initial sort set using data-sortlist attribute (see HTML below)
               $(".table2").tablesorter({
                    theme: 'blackice',
                    headerTemplate: '{content}{icon}',
                    onRenderTemplate: null
                  });
            });
        </script>

        
        <script>
            // Script para realizar la busqueda 
            $(document).ready(function() {
                $("#search-button").click(function() {
                    // Obtener el valor del input de búsqueda.
                    var filter = $("#search-input").val().toUpperCase();

                    // Iterar por cada fila de la tabla y ocultar las filas que no coinciden con el filtro de búsqueda.
                    $(".table-row").each(function() {
                        var row_text = $(this).text().toUpperCase();
                        if (row_text.indexOf(filter) > -1) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                });
            });
        </script>

        <script>
            // Script para eliminar-limpiar la busqueda 
            function clearTable() {
                document.getElementById("search-input").value = ""; // Borra el contenido del input de búsqueda
                document.getElementById("search-button").click(); // Ejecuta el evento de clic en el botón de búsqueda
            }
        </script> 

        <script>
          $(document).ready(function () {
            // Add checkboxes to each row
            $("tbody tr").prepend("<td><input type='checkbox' class='row-checkbox'></td>");

            $("#delete-selected-button").click(function () {
              var selectedRows = $("tbody tr").has("input.row-checkbox:checked");

              // Select all checkboxes
              if ($(this).is("#select-all-checkbox")) {
                $("tbody tr").find(".row-checkbox").prop("checked", this.checked);
              }

              if (selectedRows.length > 0) {
                // Get values of selected rows
                var tweetIds = selectedRows.map(function() {
                  var tweetIdStr = $(this).find("td:nth-child(2)").text().trim().replace(/\s+/g, '');
                  var match = tweetIdStr.match(/^\d+/);
                  return match ? match[0] : null;
                }).get();

                if (confirm("¿Seguro desea eliminar estos Tweets de la tabla?")) {
                  // Send selected tweet values to server
                  var tweetIdsString = JSON.stringify(tweetIds);
                  var url = "eliminar_tweet.php";
                  var data = { tweet_ids: tweetIdsString };

                  $.post(url, data, function (response) {
                    console.log(response);
                  });

                  // Remove selected rows from table
                  selectedRows.remove();
                  //alert("Selected tweets have been successfully deleted.");
                }
              } else {
                alert("Seleccione al menos un Tweet para borrar.");
              }
            });
          });
        </script>










    </head>
    <body>
        <header>
            <h1>Tweets en la Tabla</h1>
        </header>
        <div class="btn-group">
            <button onclick="location.href='menu.html'">Regresar a menu</button>
            <button onclick="location.href='exporta_excel_tweets.php'">Exporta a Excel</button>
            <button type="button" id="delete-selected-button" class="delete-button" style="margin-left: 10px;">Eliminar seleccionados</button>

        </div>

        <div class="search-container">
            <input type="text" id="search-input" class="search-box" placeholder="Buscar...">
            <button type="button" id="search-button" class="search-button">Buscar</button>
            <button type="button" id="clear-button" class="clear-button" onclick="clearTable()">&#8634;</button>
        </div>

        

        <div class='notita'> *Puede ordenar la tabla dando clik sobre alguna de las columnas </div>
        <table>
            <?php
                require_once 'conexion.php';
                $total_retweets = 0;
                $total_likes = 0;
                $contador_tweets = 0 ;

                // Consulta para obtener los registros de la tabla "tweets"
                $sql = "SELECT * FROM tweets";
                $resultado = mysqli_query($conn, $sql);
                
                // Mostrar los registros en una tabla HTML
                echo "<table class='table2' data-sortlist='[[0,0],[2,0]]''>";
                //echo "<thead><tr><th>ID</th><th>Fecha de creacion</th><th>Texto</th><th>ID de usuario</th><th>Nombre de usuario</th><th>Seguidores</th><th>Siguiendo</th><th>Retweets</th><th>Likes</th><th>Hashtags</th><th>Menciones</th></tr></thead>";
                echo "<thead><tr><th>Sel</th><th>ID</th><th>Fecha de creacion</th><th>Texto</th><th>ID de usuario</th><th>Nombre de usuario</th><th>Seguidores</th><th>Siguiendo</th><th>Retweets</th><th>Likes</th><th>Hashtags</th><th>Menciones</th></tr></thead>";

                echo "<tbody>";
                while ($fila = mysqli_fetch_assoc($resultado)) {
                    echo "<tr class='table-row'>";
                    echo "<td>" . $fila["tweet_id"] . "</td>";
                    echo "<td>" . $fila["created_at"] . "</td>";
                    echo "<td>" . $fila["text"] . "</td>";
                    echo "<td>" . $fila["user_id"] . "</td>";
                    echo "<td>" . $fila["user_name"] . "</td>";
                    echo "<td>" . $fila["seguidores"] . "</td>";
                    echo "<td>" . $fila["siguiendo"] . "</td>";
                    echo "<td>" . $fila["retweets"] . "</td>";
                    echo "<td>" . $fila["likes"] . "</td>";
                    echo "<td>" . $fila["hashtags"] . "</td>";
                    echo "<td>" . $fila["menciones"] . "</td>";
                    echo "</tr>";
                    $total_retweets = $total_retweets + $fila["retweets"] ;
                    $total_likes = $total_likes + $fila["likes"] ;
                    $contador_tweets++ ; 
                }
                echo "</tbody></table>";
                echo "<div style='text-align: right; margin-top: 20px; margin-right:50px'>";
                echo "Total de Tweets: <b>" . number_format($contador_tweets) . "</b><br>";
                echo "Total Retweets: <b>" . number_format($total_retweets) . "</b><br>";
                echo "Total Likes: <b>" . number_format($total_likes) . "</b>";
                echo "</div>";
            ?>
        </table>
        
    </body>
</html>